<?php $__env->startSection('title', __('lang_v1.product_stock_details')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(__('lang_v1.product_stock_details')); ?></h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary" id="accordion">
              <div class="box-header with-border">
                <h3 class="box-title">
                  <a data-toggle="collapse" data-parent="#accordion" href="#collapseFilter">
                    <i class="fa fa-filter" aria-hidden="true"></i> <?php echo e(app('translator')->getFromJson('report.filters')); ?>
                  </a>
                </h3>
              </div>
              <div id="collapseFilter" class="panel-collapse active collapse in" aria-expanded="true">
                <div class="box-body">
                    <div class="row">
                        <?php echo Form::open(['url' => action('ReportController@productStockDetails'), 'method' => 'get' ]); ?>

                        <div class="col-md-4">
                            <div class="form-group">
                            <?php echo Form::label('search_product', __('lang_v1.search_product') . ':'); ?>

                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-search"></i>
                                    </span>
                                    <?php echo Form::select('variation_id', [], null, ['class' => 'form-control', 'id' => 'variation_id', 'placeholder' => __('lang_v1.search_product_placeholder')]);; ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <?php echo Form::label('location_id', __('purchase.business_location').':'); ?>

                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-map-marker"></i>
                                    </span>
                                    <?php echo Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']);; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <br>
                                <button type="submit" class="btn btn-primary"><?php echo e(app('translator')->getFromJson('lang_v1.search')); ?></button>
                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>

                    <?php if(!empty($stock_details)): ?>
                        <div class="col-md-12">
                        <hr>
                        <div class="row">
                            <table class="table">
                                <tr>
                                    <th>
                                        Product
                                    </th>
                                    <th>
                                        <?php echo e(__('report.opening_stock')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('home.total_purchase')); ?>:
                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_purchase_return')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('report.total_stock_adjustment')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_stock_transfered_to_the_location')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_sold')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_sell_return')); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_stock_transfered_from_the_location')); ?>

                                    </th>
                                    <th>
                                        Correct Stock
                                        <small>(<?php echo e(__('lang_v1.total_stock_calculated')); ?>)</small>
                                    </th>
                                    <th>
                                        Incorrect Stock
                                        <small>(<?php echo e(__('lang_v1.total_stock_available')); ?>)</small>
                                    </th>
                                    <th>
                                        Fix
                                    </th>
                                </tr>

                            <?php $__currentLoopData = $stock_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $stock_mismatch = $row->stock - $row->total_stock_calculated;
                                ?>
                                <?php if($stock_mismatch == 0): ?>
                                    <?php continue; ?>
                                <?php endif; ?>

                                <tr>
                                    <td>
                                        <?php echo e($row->product); ?> 
                                        <?php if($row->type == "variable"): ?>     
                                            <?php echo e($row->product_variation); ?> - <?php echo e($row->variation_name); ?> (<?php echo e($row->sub_sku); ?>) 
                                        <?php else: ?> 
                                            (<?php echo e($row->sku); ?>) 
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php echo e($row->total_opening_stock); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_purchased); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_purchase_return); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_adjusted); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sell_transfered); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sold); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sell_return); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sell_transfered); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_stock_calculated); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->stock); ?>

                                    </td>
                                    <td>
                                        <a href="<?php echo e(action('ReportController@adjustProductStock')); ?>?location_id=<?php echo e($location->id); ?>&variation_id=<?php echo e($row->variation_id); ?>&stock=<?php echo e($row->total_stock_calculated); ?>" class="btn btn-primary">Fix</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                        </div>
                    <?php endif; ?>
                </div>
              </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade view_register" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v)); ?>"></script>
    <script type="text/javascript">
        $(document).ready( function () {
            //get customer
            $('#variation_id').select2({
                ajax: {
                    url: '/purchases/get_products',
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                          term: params.term, // search term
                        };
                    },
                    processResults: function (data) {
                        var data_formated = [];
                        data.forEach(function (item) {
                            var temp = {
                                'id': item.variation_id,
                                'text': item.text
                            }
                            data_formated.push(temp);
                        });
                        return {
                            results: data_formated
                        };
                    }
                },
                minimumInputLength: 1,
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>